ORCA/M Asm65816 2.1.0

0001 6743                       title 'Dialog Mgr Patch        GS ROM 3 Patch' 
0002 6743              ******************************************************************
0003 6743              *
0004 6743              * Dialog manager patches for ROM 3
0005 6743              *
0006 6743              * System Disk 5.0
0007 6743              *
0008 6743              * 19 May 89         Steven Glass
0009 6743              *
0010 6743              * Patch to DialogStartup so that we startup anyway if it had
0011 6743              * been started before.
0012 6743              *
0013 6743              * 31 May 89         Harry Yee
0014 6743              *
0015 6743              * Take out prototype bit in version number. (Final version = 3.1 
0016 6743              * for System Disk 5.0)
0017 6743              *
0018 6743              * 9/7/89            Mensch
0019 6743              *
0020 6743              * Fixed handle allocation bug in startup. Handle was being allocated 
0021 6743              * as moveable, then derefed and turned into many pointers... it will now
0022 6743              * be allocated as locked.
0023 6743              *
0024 6743              * 24-Sep-90         Dave Lyons
0025 6743              *
0026 6743              * Version $8304.
0027 6743              *
0028 6743              * DialogStartup now calls ErrorSound(nil).
0029 6743              * ErrorSound(nil) uses new-and-improved standard sound procedure
0030 6743              * that calls SysBeep2 (8000=alert stage 0, 1..3 = stage 1..3, and
0031 6743              * 4 = clicked outside window).  The Carry flag is set on entry
0032 6743              * to the sound proc if the user clicked outside a window.
0033 6743              *
0034 6743              * 18-Feb-91         Dave Lyons
0035 6743              *
0036 6743              * Changed the default sound proc so that it uses bit 14 of SysBeep2
0037 6743              * intelligently (for deferring sounds until the next GetNextEvent).
0038 6743              *
0039 6743              * 5-Mar-91          Dave Lyons
0040 6743              *
0041 6743              * First cut at doing I-Beam cursor handling when bit 30 of the
0042 6743              * ModalDialog filter proc is set.  Patched ModalDialog.  No need
0043 6743              * to patch ModalDialog2, since it calls ModalDialog through the
0044 6743              * tool dispatcher.
0045 6743              *
0046 6743              * 7-Mar-91          Dave Lyons
0047 6743              *
0048 6743              * Second try at I-Beam cursor stuff.  It was a bad idea to set an
0049 6743              * arrow cursor on the way in and out of every ModalDialog call
0050 6743              * when they had the bit set.  Instead, now CloseDialog calls
0051 6743              * InitCursor if ModalDialog left the cursor as an I-Beam.
0052 6743              *
0053 6743              * 10-Jun-91 DAL
0054 6743              *
0055 6743              * Removed check for active editLine item from ModalDialogCursorPoll.
0056 6743              * Now we use an IBeam cursor over all editLines, even if they are
0057 6743              * inactive.
0058 6743              *
0059 6743              * Patched out NoteAlert, CautionAlert, and StopAlert to use some
0060 6743              * colorful icons, instead of boring black-and-white ones.  We jump
0061 6743              * back into ROM as soon as everything is set up.
0062 6743              *
0063 6743              * 26-Aug-91         Dave Lyons
0064 6743              *
0065 6743              * Added check in CreateIcon for dialog at odd X position.  If odd,
0066 6743              * we make the icon position (local coordinates) odd too, so the colors
0067 6743              * will be right.
0068 6743              *
0069 6743              * 13-Oct-91         Dave Lyons
0070 6743              *
0071 6743              * In 320 mode, NoteAlert, StopAlert, and CautionAlert were putting
0072 6743              * their icons at X=0 instead of X=20.  Oops, fixed.
0073 6743              *
0074 6743              * 5-Feb-92          Dave Lyons
0075 6743              *
0076 6743              * Version $0304 for 6.0 final.
0077 6743              *
0078 6743              ******************************************************************
0079 6743              *
0080 6743              * BEGIN 6.0.1
0081 6743              *
0082 6743              * 26-Jan-93         Dave Lyons
0083 6743              *
0084 6743              * Changed version to $8305 to match TOOL021.  No other change;
0085 6743              * the TOOL021 bug did not affect us.
0086 6743              *
0087 6743              * 2-Apr-93 DAL
0088 6743              *
0089 6743              * Version $0305 for 6.0.1
0090 6743              *
0091 6743              ******************************************************************
0092 6743
0093 6743                       import DialogStartup 
0094 6743
0095 6743              ****************************************************************
0096 6743              *                                                              *
0097 6743              *              Copyright (C) 1989-93                           *
0098 6743              *              All Rights Reserved                             *
0099 6743              *              Apple Computer, Inc.                            *
0100 6743              *                                                              *
0101 6743              ****************************************************************
0102 6743                       Blanks off 
0103 6743                       String asis 
0104 6743
0105 6743              ***	include 'm16.dialog'
0106 6743                       include 'all.macros'           ;5-Mar-91 DAL
0107 6743
0108 6743              DialogCallTable PROC EXPORT 
0109 6743
0110 6743                       import DialogVersion 
0111 6743                       import NewDialogStartup 
0112 6743                       import ErrorSound 
0113 6743                       import ModalDialog             ;5-Mar-91 DAL
0114 6743                       import CloseDialog             ;7-Mar-91 DAL
0115 6743                       import StopAlert               ;10-Jun-91 DAL
0116 6743                       import NoteAlert               ;10-Jun-91 DAL
0117 6743                       import CautionAlert            ;10-Jun-91 DAL
0118 6743
0119 6743 3B 00 00 00  FPT      DC L:(ENDFPT-FPT)/4
0120 6747 00 00 00 00           DC L:0                         ; DialogBootInit-1    1
0121 674B 38 6B 02 00           DC L:NewDialogStartup-1        ;                     2
0122 674F 00 00 00 00           DC L:0                         ; DialogShutDown-1    3
0123 6753 2E 6B 02 00           DC L:DialogVersion-1           ;                     4
0124 6757 00 00 00 00           DC L:0                         ; DialogReset-1       5
0125 675B 00 00 00 00           DC L:0                         ; DialogStatus-1      6
0126 675F 00 00 00 00           DC L:0                         ; ErrorSound-1        7
0127 6763 00 00 00 00           DC L:0                         ; SetDAFont-1         8
0128 6767 5E 6B 02 00           DC L:ErrorSound-1              ;                     9
0129 676B 00 00 00 00           DC L:0                         ; NewModalDialog-1    10
0130 676F 00 00 00 00           DC L:0                         ; NewModelessDialog-1 11
0131 6773 A5 6B 02 00           DC L:CloseDialog-1             ;                     12 patched 7-Mar-91 DAL
0132 6777 00 00 00 00           DC L:0                         ; NewDItem-1          13
0133 677B 00 00 00 00           DC L:0                         ; RemoveItem-1        14
0134 677F BF 6B 02 00           DC L:ModalDialog-1             ;                     15 patched 5-Mar-91 DAL
0135 6783 00 00 00 00           DC L:0                         ; IsDialogEvent-1     16
0136 6787 00 00 00 00           DC L:0                         ; DialogSelect-1      17
0137 678B 00 00 00 00           DC L:0                         ; DlgCut-1            18
0138 678F 00 00 00 00           DC L:0                         ; DlgCopy-1           19
0139 6793 00 00 00 00           DC L:0                         ; DlgPaste-1          20
0140 6797 00 00 00 00           DC L:0                         ; DlgDelete-1         21
0141 679B 00 00 00 00           DC L:0                         ; DrawDialog-1        22
0142 679F 00 00 00 00           DC L:0                         ; Alert-1             23
0143 67A3 7C 6C 02 00           DC L:StopAlert-1               ;                     24
0144 67A7 81 6C 02 00           DC L:NoteAlert-1               ;                     25
0145 67AB 86 6C 02 00           DC L:CautionAlert-1            ;                     26
0146 67AF 00 00 00 00           DC L:0                         ; ParamText-1         27
0147 67B3 00 00 00 00           DC L:0                         ; SetDAFont-1         28
0148 67B7 00 00 00 00           DC L:0                         ; SetItemToControl-1  29
0149 67BB 00 00 00 00           DC L:0                         ; GetControlDItem-1   30
0150 67BF 00 00 00 00           DC L:0                         ; GetIText-1          31
0151 67C3 00 00 00 00           DC L:0                         ; SetIText-1          32
0152 67C7 00 00 00 00           DC L:0                         ; SelIText-1          33
0153 67CB 00 00 00 00           DC L:0                         ; HideDItem-1         34
0154 67CF 00 00 00 00           DC L:0                         ; ShowDItem-1         35
0155 67D3 00 00 00 00           DC L:0                         ; FindDItem-1         36
0156 67D7 00 00 00 00           DC L:0                         ; UpdateDialog-1      37
0157 67DB 00 00 00 00           DC L:0                         ; GetItemType-1       38
0158 67DF 00 00 00 00           DC L:0                         ; SetItemType-1       39
0159 67E3 00 00 00 00           DC L:0                         ; GetItemBox-1        40
0160 67E7 00 00 00 00           DC L:0                         ; SetItemBox-1        41
0161 67EB 00 00 00 00           DC L:0                         ; GetFirstItem-1      42
0162 67EF 00 00 00 00           DC L:0                         ; GetNextItem-1       43
0163 67F3 00 00 00 00           DC L:0                         ; ModalDialog2-1      44
0164 67F7 00 00 00 00           DC L:0                         ; RESERVED-1          45
0165 67FB 00 00 00 00           DC L:0                         ; GetItemValue-1      46
0166 67FF 00 00 00 00           DC L:0                         ; SetItemValue-1      47
0167 6803 00 00 00 00           DC L:0                         ; RESERVED-1          48
0168 6807 00 00 00 00           DC L:0                         ; RESERVED-1          49
0169 680B 00 00 00 00           DC L:0                         ; GetNewModalDialog-1 50
0170 680F 00 00 00 00           DC L:0                         ; GetNewDItem-1       51
0171 6813 00 00 00 00           DC L:0                         ; GetAlertStage-1     52
0172 6817 00 00 00 00           DC L:0                         ; ResetAlertStage-1   53
0173 681B 00 00 00 00           DC L:0                         ; DefaultFilter-1     54
0174 681F 00 00 00 00           DC L:0                         ; GetDefButton-1      55
0175 6823 00 00 00 00           DC L:0                         ; SetDefButton-1      56
0176 6827 00 00 00 00           DC L:0                         ; DisableDItem-1      57
0177 682B 00 00 00 00           DC L:0                         ; EnableDItem-1       58
0178 682F              ENDFPT    
0179 682F                       ENDP 
0180 682F
0181 682F              *************************************************************************
0182 682F              *
0183 682F              * DialogVersion patch
0184 682F              *
0185 682F              *************************************************************************
0186 682F              DialogVersion PROC 
0187 682F
0188 682F A9 05 03              lda   #$0305                   ;2-Apr-93 DAL
0189 6832 83 07                 sta   7,s
0190 6834 A9 00 00              lda   #0
0191 6837 18                    clc   
0192 6838 6B                    rtl   
0193 6839
0194 6839                       ENDP 
0195 6839
0196 6839              **************************************************************************
0197 6839              *
0198 6839              * 24-Sep-90 DAL
0199 6839              *
0200 6839              * Now calls ErrorSound(nil) after calling the ROM startup function
0201 6839              *
0202 6839              * (The patch to load AY=nil before calling the ROM was already here.)
0203 6839              *
0204 6839              **************************************************************************
0205 6839              NewDialogStartup PROC 
0206 6839
0207 6839 A3 07                 lda   7,s
0208 683B 48                    pha   
0209 683C A9 00 00              lda   #0
0210 683F A8                    tay   
0211 6840 22 5A 6B 02           jsl   @toStartup               ;call with WAP=0
0212 6844 B0 0C                 bcs   @exit
0213 6846 A9 00 00              lda   #0
0214 6849 48                    pha   
0215 684A 48                    pha   
0216 684B A2 15 09 22           _ErrorSound 
0217 6852 AA           @exit    tax   
0218 6853 A0 02 00              ldy   #2                       ;strip 2 bytes
0219 6856 5C 84 01 E1           jml   $e10184                  ;ToStrip
0220 685A
0221 685A 22 6D 6D 02  @toStartup jsl   DialogStartup
0222 685E 6B                    rtl   
0223 685F
0224 685F                       ENDP 
0225 685F
0226 685F
0227 685F              **************************************************************************
0228 685F              *
0229 685F              * ErrorSound patch
0230 685F              *
0231 685F              * New patch 24-Sep-90 DAL
0232 685F              *
0233 685F              * ErrorSound(nil) defaults to nifty-new sound proc.
0234 685F              *
0235 685F              **************************************************************************
0236 685F              ErrorSound PROC 
0237 685F
0238 685F AA                    tax   
0239 6860 A3 07                 lda   7,s
0240 6862 03 09                 ora   9,s
0241 6864 D0 0A                 bne   @toROM
0242 6866
0243 6866 A9 02 00              lda   #^NewSoundProc
0244 6869 83 09                 sta   9,s
0245 686B A9 75 6B              lda   #<NewSoundProc
0246 686E 83 07                 sta   7,s
0247 6870
0248 6870 8A           @toROM   txa   
0249 6871 5C CF 67 FC           jml   $fc67cf
0250 6875
0251 6875              *************************************************************************
0252 6875              *
0253 6875              * NewSoundProc--input is one word on stack (needs to be removed).
0254 6875              *
0255 6875              * If the carry is set, the user clicked outside a dialog window,
0256 6875              * so we need to call SysBeep2($0004).  If the carry is clear, the
0257 6875              * word on the stack is the alert stage (0..3).  Stage 0 makes no
0258 6875              * sound by default so we call SysBeep2($C000).  Stages 1..3 map to
0259 6875              * SysBeep2(4001..4003).
0260 6875              *
0261 6875              * (Setting bit 14 defers the sound until the next GetNextEvent call.)
0262 6875              *
0263 6875              NewSoundProc  
0264 6875
0265 6875              *** Let's try this one more time, using bit 14 of SysBeep2 this time to delay
0266 6875              *** the beeps until GetNextEvent gets called.  17-Feb-91 DAL
0267 6875
0268 6875 A3 01                 lda   1,s
0269 6877 C9 A4 7F              cmp   #$7fa4
0270 687A D0 0C                 bne   @notOutsideWindow
0271 687C A3 02                 lda   2,s
0272 687E C9 7F FC              cmp   #$fc7f
0273 6881 D0 05                 bne   @notOutsideWindow
0274 6883 A9 04 00              lda   #$0004                   ;clicked outside dialog/alert
0275 6886 80 0C                 bra   @thisSound
0276 6888 A3 04        @notOutsideWindow lda   4,s
0277 688A F0 05                 beq   @stage0
0278 688C 09 00 40              ora   #$4000                   ;stage 1..3: $4001..4003 (defer until GetNextEvent)
0279 688F 80 03                 bra   @thisSound
0280 6891 A9 00 C0     @stage0  lda   #$C000                   ;stage 0: no sound by default, defer until GNE
0281 6894 48           @thisSound pha   
0282 6895 A2 03 38 22           _SysBeep2 
0283 689C A3 02                 lda   2,s
0284 689E 83 04                 sta   4,s
0285 68A0 A3 01                 lda   1,s
0286 68A2 83 03                 sta   3,s
0287 68A4 68                    pla   
0288 68A5 6B                    rtl   
0289 68A6
0290 68A6                       EndP 
0291 68A6
0292 68A6
0293 68A6              **************************************************************************
0294 68A6              *
0295 68A6              * CloseDialog patch
0296 68A6              *
0297 68A6              * New patch 7-Mar-91 DAL
0298 68A6              *
0299 68A6              * If ModalDialog left the cursor as an I-Beam, call InitCursor.
0300 68A6              *
0301 68A6              **************************************************************************
0302 68A6              CloseDialog proc export 
0303 68A6                       import IBeamFlag 
0304 68A6
0305 68A6 48                    pha                            ;save WAP
0306 68A7 AF F3 6B 02           lda   >IBeamFlag
0307 68AB F0 0E                 beq   @notIBeam
0308 68AD A9 00 00              lda   #0
0309 68B0 8F F3 6B 02           sta   >IBeamFlag
0310 68B4 A2 04 CA 22           _InitCursor 
0311 68BB 68           @notIBeam pla                           ;get WAP back
0312 68BC 5C CB 6A FC           jml   >$fc6acb                 ;original ROM 3 CloseDialog
0313 68C0
0314 68C0                       EndP 
0315 68C0
0316 68C0
0317 68C0              **************************************************************************
0318 68C0              *
0319 68C0              * ModalDialog patch
0320 68C0              *
0321 68C0              * New patch 5-Mar-91 DAL
0322 68C0              *
0323 68C0              * Patch to support I-Beam stuff if they set bit 30 of the filter proc
0324 68C0              * parameter.
0325 68C0              *
0326 68C0              * On the way in:    Call InitCursor if they set bit 30.
0327 68C0              *                   Initialize IBeamFlag.
0328 68C0              *
0329 68C0              * During the call:  Get control when ModalDialog calls GetNextEvent, so we
0330 68C0              *                   can fiddle with the cursor then.
0331 68C0              *
0332 68C0              * Afterwards:       If the cursor is an I-Beam, make it back into an arrow.
0333 68C0              *
0334 68C0              * Inputs:
0335 68C0              *     WORD  space for result
0336 68C0              *     LONG  filter proc pointer
0337 68C0              *
0338 68C0              **************************************************************************
0339 68C0              ModalDialog PROC 
0340 68C0
0341 68C0 48                    pha                            ;save the WAP for a second
0342 68C1
0343 68C1 A3 09                 lda   7+2,s
0344 68C3 8F F5 6B 02           sta   >FilterProcCopy
0345 68C7 A3 0B                 lda   7+2+2,s
0346 68C9 8F F7 6B 02           sta   >FilterProcCopy+2
0347 68CD
0348 68CD              *** InitCursor on the way in is a bad idea (7-Mar-91 DAL)
0349 68CD              ;	and	#$4000	;check bit 30
0350 68CD              ;	beq	@noInit
0351 68CD              ;	_InitCursor
0352 68CD              ;@noInit
0353 68CD
0354 68CD A9 00 00              lda   #0
0355 68D0 8F F3 6B 02           sta   >IBeamFlag
0356 68D4
0357 68D4 FA                    plx                            ;old WAP
0358 68D5
0359 68D5 A3 0B                 lda   7+4,s
0360 68D7 48                    pha                            ;push copy of resull space
0361 68D8 A3 0B                 lda   7+4,s
0362 68DA 48                    pha   
0363 68DB A3 0B                 lda   7+4,s
0364 68DD 48                    pha                            ;pushed copy of filter proc
0365 68DE 8A                    txa   
0366 68DF 22 EE 6B 02           jsl   @toROM
0367 68E3 AA                    tax                            ;save error code
0368 68E4 68                    pla                            ;pull result from ROM code
0369 68E5 83 0B                 sta   11,s                     ;stored new result
0370 68E7
0371 68E7              ;*** Setting the cursor on the way out of ModalDialog is a bad idea
0372 68E7              ;*** Fix up the cursor if necessary
0373 68E7              ;	phx	;error code
0374 68E7              ;	lda	>IBeamFlag
0375 68E7              ;	beq	@okay
0376 68E7              ;	_InitCursor
0377 68E7              ;@okay	plx	;restore error code
0378 68E7
0379 68E7 A0 04 00              ldy   #4
0380 68EA 5C 84 01 E1           jml   $e10184                  ;ToStrip
0381 68EE
0382 68EE 22 55 7D FC  @toROM   jsl   $fc7d55                  ;original ROM 3 ModalDialog
0383 68F2 6B                    rtl   
0384 68F3
0385 68F3                       entry IBeamFlag 
0386 68F3 00 00        IBeamFlag DC W:0
0387 68F5
0388 68F5                       entry FilterProcCopy 
0389 68F5 00 00 00 00  FilterProcCopy DC L:0
0390 68F9
0391 68F9                       EndP 
0392 68F9
0393 68F9
0394 68F9              **************************************************************************
0395 68F9              *
0396 68F9              * ModalDialogCursorPoll -- new routine 5-Mar-91 DAL
0397 68F9              *
0398 68F9              * The GetNextEvent patch calls this routine when it sees it's being
0399 68F9              * called from ModalDialog.
0400 68F9              *
0401 68F9              * We check filter proc bit 30 to see if we're supposed to mess with the
0402 68F9              * cursor.  If we are, we need to get the cursor position and change the
0403 68F9              * cursor to an arrow or I-Beam appropriately.
0404 68F9              *
0405 68F9              * Replaced most of this code 7-Mar-91 DAL because we can't call FindDItem;
0406 68F9              * that makes an item think it's been clicked on.
0407 68F9              *
0408 68F9              * 22-Mar-91 DAL
0409 68F9              *   Added missing CLC in ModalDialogCursorPoll.
0410 68F9              *
0411 68F9              **************************************************************************
0412 68F9              ModalDialogCursorPoll proc export  
0413 68F9                       import IBeamFlag 
0414 68F9                       import FilterProcCopy 
0415 68F9
0416 68F9              @event   equ $0 
0417 68F9              @where   equ 10                         ;offset into event record
0418 68F9
0419 68F9 AF F7 6B 02           lda   >filterProcCopy+2
0420 68FD 29 00 40              and   #$4000
0421 6900 D0 01                 bne   @1
0422 6902              ***	brl	@veryBoring
0423 6902 6B                    rtl   
0424 6903              @1        
0425 6903              ; find the item the cursor is over
0426 6903
0427 6903 F4 00 00              pea   0
0428 6906 7B                    tdc   
0429 6907 18                    clc                            ;added 22-Mar-91 DAL
0430 6908 69 0A 00              adc   #@event+@where
0431 690B 48                    pha   
0432 690C A2 04 85 22           _GlobalToLocal 
0433 6913
0434 6913 48                    pha                            ;space for FindCursorCtl
0435 6914 F4 02 00 F4           pushlong #theControlH 
0436 691A D4 0C                 pei   <@event+@where+2
0437 691C D4 0A                 pei   <@event+@where
0438 691E 48                    pha   
0439 691F 48                    pha   
0440 6920 A2 0E 15 22           _FrontWindow 
0441 6927 A2 0E 69 22           _FindCursorCtl 
0442 692E 68                    pla                            ;part code
0443 692F F0 33                 beq   @nonLineEdit
0444 6931
0445 6931 48                    pha   
0446 6932 48                    pha                            ;space for GetCtlRefCon
0447 6933 AF 7B 6C 02           pushlong >theControlH 
0448 693D A2 10 23 22           _GetCtlRefCon 
0449 6944 68                    pla                            ;dItem number
0450 6945 68                    pla   
0451 6946 29 FF 7F              and   #$7fff                   ;dialog item type
0452 6949 C9 11 00              cmp   #$0011                   ;Line Edit item?
0453 694C D0 16                 bne   @nonLineEdit
0454 694E
0455 694E AF F3 6B 02  @isLineEdit lda   >IBeamFlag
0456 6952 D0 24                 bne   @cursorOkay              ;already an I-Beam cursor
0457 6954 A9 01 00              lda   #1
0458 6957 8F F3 6B 02           sta   >IBeamFlag
0459 695B A2 12 13 22           _IBeamCursor 
0460 6962 80 14                 bra   @cursorOkay
0461 6964
0462 6964 AF F3 6B 02  @nonLineEdit lda   >IBeamFlag
0463 6968 F0 0E                 beq   @cursorOkay              ;already an arrow cursor
0464 696A A9 00 00              lda   #0
0465 696D 8F F3 6B 02           sta   >IBeamFlag
0466 6971 A2 04 CA 22           _InitCursor 
0467 6978              @cursorOkay  
0468 6978 6B           @veryBoring rtl   
0469 6979
0470 6979 00 00 00 00  theControlH DC L:0
0471 697D
0472 697D                       EndP 
0473 697D
0474 697D
0475 697D              **************************************************************************
0476 697D              *
0477 697D              * StopAlert patch 10-Jun-91 DAL for colored icons
0478 697D              *
0479 697D              **************************************************************************
0480 697D              StopAlert proc export 
0481 697D
0482 697D A2 01 00              ldx   #1
0483 6980 80 08                 bra   GeneralAlert
0484 6982
0485 6982              **************************************************************************
0486 6982              *
0487 6982              * NoteAlert patch 10-Jun-91 DAL for colored icons
0488 6982              *
0489 6982              **************************************************************************
0490 6982                       entry NoteAlert 
0491 6982 A2 02 00     NoteAlert ldx   #2
0492 6985 80 03                 bra   GeneralAlert
0493 6987
0494 6987              **************************************************************************
0495 6987              *
0496 6987              * CautionAlert patch 10-Jun-91 DAL for colored icons
0497 6987              *
0498 6987              **************************************************************************
0499 6987                       entry CautionAlert 
0500 6987 A2 03 00     CautionAlert ldx   #3
0501 698A
0502 698A              GeneralAlert  
0503 698A
0504 698A                       import Icon320Table 
0505 698A                       import Icon640Table 
0506 698A
0507 698A              ;
0508 698A              ; Zero Page (shared with Control Manager)
0509 698A              ;
0510 698A              Signature equ 128                       ; contains DlgSig if Dlg Mgr active
0511 698A              mmgrID   equ Signature+2                ; ID to use with the Memory Manager
0512 698A              DialogFont equ mmgrID+2                 ; handle to dialog font or 0 for system
0513 698A              AlertSoundProc equ DialogFont+4         ; pointer to custom sound procedure
0514 698A              AlertStage equ AlertSoundProc+4         ; current alert stage
0515 698A              LastAlertID equ AlertStage+2            ; ID of last called alert
0516 698A              ParamString0 equ LastAlertID+2          ; Param strings for ^0 to ^3
0517 698A              ParamString1 equ ParamString0+4 
0518 698A              ParamString2 equ ParamString1+4 
0519 698A              ParamString3 equ ParamString2+4 
0520 698A              PartCodeHit equ ParamString3+4          ; Part Code Hit
0521 698A              MemHandle equ PartCodeHit+2 
0522 698A              WindowPointer equ MemHandle+4 
0523 698A              HandStruct equ WindowPointer+4 
0524 698A              ***EndZeroPage	equ HandStruct+4
0525 698A              IBeamFlag equ HandStruct+4              ;5-Mar-91 DAL: nonzero = we called IBeamCursor
0526 698A              EndZeroPage equ IBeamFlag+2             ;5-Mar-91 DAL
0527 698A              ;
0528 698A              ; Alert Template
0529 698A              ;
0530 698A              atBoundsRect equ 0 
0531 698A              atalertID equ atBoundsRect+8 
0532 698A              atstage1 equ atalertID+2 
0533 698A              atstage2 equ atstage1+1 
0534 698A              atstage3 equ atstage2+1 
0535 698A              atstage4 equ atstage3+1 
0536 698A              atitemlist equ atstage4+1 
0537 698A              *
0538 698A              * Local direct page stuff
0539 698A              *
0540 698A              theDialog equ 0 
0541 698A              ItemTemplate equ theDialog+4 
0542 698A              PortSave equ ItemTemplate+4 
0543 698A              Globals  equ PortSave+4 
0544 698A              StageVector equ Globals+4 
0545 698A              IconID   equ StageVector+2 
0546 698A              IconHandleStruct equ IconID+2 
0547 698A              SizeLocals equ IconHandleStruct+4 
0548 698A              ;
0549 698A              ; Icon Item Template
0550 698A              ;
0551 698A              IconitemID equ 0 
0552 698A              IconitemRect equ IconitemID+2 
0553 698A              IconitemType equ IconitemRect+8 
0554 698A              IconitemDescr equ IconitemType+2 
0555 698A              IconitemValue equ IconitemDescr+4 
0556 698A              IconitemFlag equ IconitemValue+2 
0557 698A              IconitemColor equ IconitemFlag+2 
0558 698A
0559 698A A8                    tay                            ; save d-page in y
0560 698B
0561 698B 3B 38 E9 18           tlink 8,SizeLocals 
0562 6994
0563 6994              filterProc equ input 
0564 6994              AlertTemplate equ filterProc+4 
0565 6994
0566 6994              itemHit  equ output 
0567 6994
0568 6994 86 12                 stx   <IconID                  ; save Icon ID
0569 6996
0570 6996              ;
0571 6996              ; Get Dialog Manager Zero Page
0572 6996              ;
0573 6996 84 0C                 sty   <Globals
0574 6998 64 0E                 stz   <Globals+2
0575 699A
0576 699A
0577 699A A0 AA 00              ldy   #HandStruct
0578 699D B7 0C                 lda   [<Globals],y
0579 699F 85 14                 sta   <IconHandleStruct
0580 69A1 C8                    iny   
0581 69A2 C8                    iny   
0582 69A3 B7 0C                 lda   [<Globals],y
0583 69A5 85 16                 sta   <IconHandleStruct+2
0584 69A7
0585 69A7              ;
0586 69A7              ; Is it the same alert as the last alert
0587 69A7              ;
0588 69A7 A0 08 00              ldy   #atalertID
0589 69AA B7 22                 lda   [<AlertTemplate],y
0590 69AC A0 8E 00              ldy   #LastAlertID
0591 69AF D7 0C                 cmp   [<Globals],y
0592 69B1 F0 0A                 beq   GetStage
0593 69B3
0594 69B3              ;
0595 69B3              ; If not, set lastalertID to current alert, and reset alert stage
0596 69B3              ;
0597 69B3 97 0C                 sta   [<Globals],y             ; a = AlertID, y = #LastAlertID
0598 69B5
0599 69B5 A9 00 00              lda   #0
0600 69B8 A0 8C 00              ldy   #AlertStage
0601 69BB 97 0C                 sta   [<Globals],y
0602 69BD
0603 69BD              ;
0604 69BD              ; Get the current stage of the alert
0605 69BD              ;
0606 69BD              GetStage                                ; 
0607 69BD A0 8C 00              ldy   #AlertStage              ; calculate offset to current stage
0608 69C0 B7 0C                 lda   [<Globals],y             ; in the alert template
0609 69C2 18                    clc   
0610 69C3 69 0A 00              adc   #atstage1
0611 69C6 A8                    tay   
0612 69C7 B7 22                 lda   [<AlertTemplate],y
0613 69C9 29 FF 00              and   #$FF
0614 69CC 85 10                 sta   <StageVector
0615 69CE
0616 69CE              ;
0617 69CE              ; Call the Sound Procedure
0618 69CE              ;
0619 69CE 29 03 00              and   #%00000011               ; get sound number in bits 0-1
0620 69D1 48                    pha   
0621 69D2
0622 69D2 A0 89 00              ldy   #AlertSoundProc+1        ; look if there is a custom sound proc
0623 69D5 B7 0C                 lda   [<Globals],y             ; (X = bits 8-23)
0624 69D7 88                    dey                            ; Y = AlertSoundProc
0625 69D8 AA                    tax   
0626 69D9
0627 69D9              *** There will always be a custom sound proc, because of ErrorSound/DialogStartUp
0628 69D9              *** patches above.  10-Jun-91 DAL
0629 69D9              ;	bne	CallCustomSound
0630 69D9              ;
0631 69D9              ;	lda	[<Globals],y	; test now low word
0632 69D9              ;	bne	CallCustomSound	; (A = bits 0-15)
0633 69D9              ;
0634 69D9              ;	clc		;24-Sep-90 DAL
0635 69D9              ;	jsl	StdSoundProc	; call standard sound proc
0636 69D9              ;	bra	CheckDrawn
0637 69D9
0638 69D9              CallCustomSound  
0639 69D9 B7 0C                 lda   [<Globals],y             ; X already=bits 8-23, Y=AlertSoundProc
0640 69DB 18                    clc                            ;24-Sep-90 DAL
0641 69DC 22 52 89 FC           jsl   >$fc8952                 ;long_call ; and A = low byte of procedure address
0642 69E0
0643 69E0              ;
0644 69E0              ; Look if alert box should be drawn
0645 69E0              ;
0646 69E0              CheckDrawn  
0647 69E0 A5 10                 lda   <StageVector
0648 69E2 29 80 00              and   #%10000000               ; boxdrawn is bit 7
0649 69E5 D0 04                 bne   CreateDialog
0650 69E7 5C F4 71 FC           jml   >$fc71f4                 ;IncAlertStage in ROM 3
0651 69EB
0652 69EB              ;
0653 69EB              ; Creates modal dialog for alert by calling DialogFromTemplate
0654 69EB              ;
0655 69EB              CreateDialog  
0656 69EB
0657 69EB F4 00 00 7B           pushzptr <theDialog            ; variable to store dialog ptr in
0658 69F4
0659 69F4 D4 24 D4 22           pushlongdp <AlertTemplate      ; pointer to template
0660 69F8
0661 69F8 F4 01 00              pushword #1                    ; visible
0662 69FB
0663 69FB A9 00 00              lda   #0                       ; refcon = 0
0664 69FE 48                    pha   
0665 69FF 48                    pha   
0666 6A00
0667 6A00 A9 0E 00              lda   #atitemlist              ; offset to item list
0668 6A03 48                    pha   
0669 6A04
0670 6A04 22 1F 6B FC           jsl   >$FC6B1F                 ;DialogFromTemplate--create dialog and set error status
0671 6A08
0672 6A08 90 04                 bcc   AddIcon                  ; error!, exit
0673 6A0A
0674 6A0A 5C 04 72 FC           jml   >$fc7204                 ;exit in ROM 3
0675 6A0E
0676 6A0E              ;
0677 6A0E              ; Then add the alert icon
0678 6A0E              ;
0679 6A0E A5 12        AddIcon  lda   <IconID
0680 6A10 F0 57                 beq   SetDef                   ; no icon
0681 6A12
0682 6A12 3A                    dec   a                        ; compute index to icon pointer
0683 6A13 0A                    asl   a
0684 6A14 0A                    asl   a
0685 6A15 AA                    tax   
0686 6A16
0687 6A16              ;
0688 6A16              ; Assume we're in 640 mode
0689 6A16              ;
0690 6A16 BF EC 6D 02           lda   >Icon640Table,x          ; get icon pointer from 640 table
0691 6A1A 87 14                 sta   [<IconHandleStruct]      ; and store in fake handle
0692 6A1C BF EE 6D 02           lda   >Icon640Table+2,x
0693 6A20 A0 02 00              ldy   #2
0694 6A23 97 14                 sta   [<IconHandleStruct],y
0695 6A25
0696 6A25              ;
0697 6A25              ; See if we are in 320 or 640
0698 6A25              ;
0699 6A25 A7 00                 lda   [<theDialog]             ; get PortSCB
0700 6A27 29 80 00              and   #$0080                   ; 0=320, 1=640
0701 6A2A D0 0F                 bne   CreateIcon
0702 6A2C
0703 6A2C BF E0 6D 02           lda   >Icon320Table,x          ; get icon pointer from 320 table
0704 6A30 87 14                 sta   [<IconHandleStruct]      ; and store in fake handle
0705 6A32 BF E2 6D 02           lda   >Icon320Table+2,x
0706 6A36 A0 02 00              ldy   #2
0707 6A39 97 14                 sta   [<IconHandleStruct],y
0708 6A3B
0709 6A3B              ;;;;;CreateIcon	jml	>$FC716E	;CreateIcon in ROM 3
0710 6A3B
0711 6A3B 3B           CreateIcon tsc                          ; make room on the stack for icon template
0712 6A3C 38                    sec   
0713 6A3D E9 18 00              sbc   #24
0714 6A40 1B                    tcs   
0715 6A41
0716 6A41 1A                    inc   a                        ; store starting address of icon template in x
0717 6A42 AA                    tax   
0718 6A43
0719 6A43 A9 00 80              lda   #-32768                  ; store icon ID
0720 6A46 83 01                 sta   iconitemID+1,s
0721 6A48 A9 05 00              lda   #5                       ; store icon boundaries
0722 6A4B 83 03                 sta   iconitemRect+1,s
0723 6A4D              *** added 26-Aug-91 DAL -- if 640 and dialog is at odd location, compensate
0724 6A4D A7 00                 lda   [<theDialog]
0725 6A4F 29 80 00              and   #$0080
0726 6A52              *** added 13-Oct-91 DAL -- A was supposed to be 20 for 320 mode
0727 6A52 08                    php   
0728 6A53 A9 14 00              lda   #20
0729 6A56 28                    plp   
0730 6A57              *** end 13-Oct-91
0731 6A57 F0 0C                 beq   @1                       ;320 is no problem
0732 6A59 A0 0A 00              ldy   #10                      ;offset into port of boundsRect.x1
0733 6A5C B7 00                 lda   [<theDialog],y
0734 6A5E 4A                    lsr   a
0735 6A5F A9 14 00              lda   #20                      ;used to always be 20, now can be 19 instead
0736 6A62 90 01                 bcc   @1                       ;it's even, no problem
0737 6A64 3A                    dec   a                        ;A=19
0738 6A65              @1        
0739 6A65              *** end 26-Aug-91
0740 6A65 5C 83 71 FC           jml   >$fc7183
0741 6A69
0742 6A69 5C BF 71 FC  SetDef   jml   >$fc71bf
0743 6A6D
0744 6A6D                       EndP 
0745 6A6D
0746 6A6D                       END   
